/*
    13/04/2022 Occhialini Lorenzo: Richiesta di Implementazione ALY-37460 (TFS N.170984) del 28/03/2022 - Task TSE-13887
    13/12/2021 Occhialini Lorenzo: Implementazione N.167144 del 05/11/2021 - Fase 167146

	Funzione che ritorna la tabella CG15_TABCAUPREST con il campo CG15_DESCR in funzione della lingua aziendale
	   
	   Parametri di input:
	      - Codice (CG15_CODICE)	         				     ---> obbligatorio (se non passato ritorna nessun record)
		  - Codice azienda                                       ---> obbligatorio (se non passato ritorna nessun record) 
*/

IF EXISTS(SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[FNCG15_TABCAUPREST]') and xtype in (N'FN', N'IF', N'TF'))
	DROP FUNCTION [dbo].FNCG15_TABCAUPREST
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE FUNCTION dbo.FNCG15_TABCAUPREST
(
    @Codice				AS CHAR(4),
 	@CodDitta			int
)
RETURNS TABLE 
AS 
RETURN
(
	SELECT     
		        CG15_CODICE, 
			    CG0L_DESCRIZIONE AS CG15_DESCR,
			    CG15_CAUSDD1, 
			    CG15_CODTRIBUTO, 
	  		    CG15_INPSIVS, 
	 		    CG15_FLGGLAD, 
	            CG15_INDCODATTGLAD,
			    CG15_PERCRA,
				CG15_FLGRITIMPOSTA,
			    CG15_IDMEDIA_CG99,
			    CG15_PERCBASEIMP,
			    CG15_CODTRIBRP, 
		        CG15_FLGREGAGEVO,
				CG15_FLGMINIMI,
			    CG15_PERCRIPAZ,
			    CG15_FLGPROTEO360,
			    CG15_INDTIPOCASSA,
			    CG15_IDPROV
	FROM        CG15_TABCAUPREST  WITH (NOLOCK)
	INNER JOIN  CG18_ANADITTABASE WITH(NOLOCK)
	              ON CG18_DITTA = @CodDitta
 	LEFT OUTER JOIN CG0L_DESLINGUA WITH (NOLOCK)
	              ON CG15_IDPROV = CG0L_IDPROV
                 AND CG0L_CODLINGUA_MG52 = CG18_CODLINGUA_MG52
				 AND CG0L_PROVID = 15
	WHERE   CG15_CODICE  =  ISNULL(@Codice , 0)
)
GO